## Naval Intrusion

The challenge involves identifying a modified Chinese naval vessel that was spotted in Taiwanese waters. A UAV captured images of the vessel, which appears to be altered from its original design and lacks clear identification markers.

## Available Materials

1. UAV photograph of the unidentified vessel  
2. Time and location context (09:43 Taipei Standard Time)  
3. Information about the vessel’s behavior (left westward for international waters)  
4. Context that the vessel appears to be modified from a known design

## Solution Path

### Step 1: Visual Analysis

When analyzing the vessel photo, focus on:

1. Overall hull design  
2. Superstructure configuration  
3. Weapon placement  
4. Sensor arrays  
5. Distinctive features of Chinese naval architecture

### Step 2: Identifying the Base Vessel

Key characteristics point to the Type 054A (Jiangkai II) Class Frigate:

* Built by Hudong-Zhonghua Shipyard and Huangpu Shipyard  
* Operated by the People’s Liberation Army Navy (PLAN)  
* Distinctive features match despite modifications

### Step 3: Format Requirements

The answer must be submitted in this specific format:

```

type-[number][letter]-[nato-reporting-name]
```

Example format:

```

type-555d-kingkong-IV
```

The correct answer format would be:

```

type-054a-jiangkai-II
```

## Key Formatting Rules

1. All lowercase for “type”  
2. Hyphen between each component  
3. NATO reporting name must match exactly (including capitalization)  
4. No spaces anywhere in the answer

## Tips for Solvers

1. Focus on base hull design rather than modifications  
2. Compare with known Chinese naval vessels  
3. Pay attention to the exact spelling and format of NATO reporting names  
4. Check PLAN (People’s Liberation Army Navy) vessel databases  
5. Verify your formatting matches the requirements exactly

## Common Pitfalls to Avoid

1. Incorrect capitalization of NATO name  
2. Missing or extra hyphens  
3. Incorrect spelling of “jiangkai”  
4. Wrong case for the letter ‘a’ in ‘054a’  
5. Adding extra spaces  
6. Using wrong Roman numerals (II vs 2\)

## Research Resources

1. Naval technology websites  
2. Maritime defense publications  
3. PLAN vessel catalogs  
4. Naval recognition guides  
5. Maritime OSINT databases

## Verification Steps

To confirm you have the correct vessel, verify:

Weapon systems align with known configurations

Matches basic hull design

Fits timeline of Chinese naval development

Operating in the expected region

Size matches reported class

